<?php

require_once('database/DBController.php');

$db = new DBController();
$conn = $db->con;

if (!isset($_SESSION['login'])) {
    // Redirect to login if user is not logged in
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Check if the user has an address
$query = "SELECT COUNT(*) AS address_count FROM user_addresses WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$addressExists = $row['address_count'] > 0;

// Get order details from GET or POST
$orderId = $_POST['orderId'] ?? $_GET['orderId'] ?? null;
$orderAmount = $_POST['orderAmount'] ?? $_GET['orderAmount'] ?? null;

if ($addressExists) {
    // Store order details in session
    $_SESSION['orderId'] = $orderId;
    $_SESSION['orderAmount'] = $orderAmount;

    // Redirect to request.php with order details
    header("Location: request.php");
    exit();
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Address Form</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

    <style>
        .container {
            max-width: 500px;
            margin: 40px auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        }
        .btn {
            width: 100%;
            background: orange;
            color: white;
            border: none;
            padding: 10px;
            font-size: 16px;
            cursor: pointer;
            border-radius: 5px;
        }
        .btn:hover {
            background: darkorange;
        }
        .progress-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            position: relative;
        }
        .progress-container::before {
            content: "";
            position: absolute;
            top: 68%;
            left: 10%;
            width: 80%;
            height: 4px;
            background: lightgray;
            z-index: 0;
            transform: translateY(-50%);
        }
        .step {
            width: 30px;
            height: 30px;
            line-height: 30px;
            border-radius: 50%;
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            background: lightgray;
            color: black;
            position: relative;
            z-index: 1;
        }
        .step.active {
            background: blue;
            color: white;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="row pt-3 pb-3" style="border-bottom: 1px solid whitesmoke;">
        <h5>Add Delivery Address</h5>        
    </div>

    <div class="progress-container pt-3 mt-3">
        <div class="step active">1</div>
        <div class="step">2</div>
        <div class="step">3</div>
        <div class="step">4</div>
    </div>

    <div class="row pt-3 pb-3" style="border-bottom: 1px solid whitesmoke;">
        <h5><i class="bi bi-geo-alt-fill"></i> Address</h5>        
    </div>
    <form method="POST" action="save_address.php">
        <input type="hidden" name="orderId" value="<?php echo htmlspecialchars($orderId); ?>">
        <input type="hidden" name="orderAmount" value="<?php echo htmlspecialchars($orderAmount); ?>">

        <div class="form-floating mb-3">
            <input type="text" class="form-control" name="full_name" id="full_name" placeholder="Full Name" required>
            <label for="full_name">Full Name *</label>
        </div>

        <div class="form-floating mb-3">
            <input type="text" class="form-control" name="phone" id="phone" placeholder="Mobile Number" required>
            <label for="phone">Mobile Number *</label>
        </div>

        <div class="form-floating mb-3">
            <input type="text" class="form-control" name="pincode" id="pincode" placeholder="Pincode" required>
            <label for="pincode">Pincode *</label>
        </div>

        <div class="row mb-3">
    <div class="col-6">
        <div class="form-floating">
            <input type="text" class="form-control" name="city" id="city" placeholder="City" required>
            <label for="city">City *</label>
        </div>
    </div>
    <div class="col-6">
        <div class="form-floating">
            <input type="text" class="form-control" name="state" id="state" placeholder="State" required>
            <label for="state">State *</label>
        </div>
    </div>
</div>


        <div class="form-floating mb-3">
            <input type="text" class="form-control" name="house_no" id="house_no" placeholder="House No., Building Name" required>
            <label for="house_no">House No., Building Name *</label>
        </div>

        <div class="form-floating mb-3">
            <input type="text" class="form-control" name="road_name" id="road_name" placeholder="Road Name, Area, Colony" required>
            <label for="road_name">Road Name, Area, Colony *</label>
        </div>

        <p><strong>Type of Address</strong></p>
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="address_type" value="Home" required>
            <label class="form-check-label">Home</label>
        </div>
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="address_type" value="Work" required>
            <label class="form-check-label">Work</label>
        </div>

        <button type="submit" class="btn mt-3">Save Address</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
