<?php
ob_start();
include 'header.php';
include 'partials/_categories_nav.php';

if (!isset($_GET['orderId']) && !isset($_POST['orderId'])) {
    header('location:index.php');
    exit();
}

$orderId = $_GET['orderId'] ?? $_POST['orderId'];
$orderAmount = $_GET['orderAmount'] ?? $_POST['orderAmount'];
?>

<style>
body {
    font-family: Arial, sans-serif;
    background-color: #f1f3f6;
    margin: 0;
    padding: 0;
}

.confirm-container {
    max-width: 600px;
    margin: 50px auto;
    background: white;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.confirm-header {
    font-size: 20px;
    font-weight: bold;
    color: #333;
}

.confirm-icon {
    font-size: 50px;
    color: #28a745;
    margin: 20px 0;
}

.confirm-message {
    font-size: 18px;
    color: #555;
}

.order-details {
    font-size: 16px;
    margin: 20px 0;
    color: #333;
    font-weight: bold;
}

.back-home-btn {
    padding: 12px 20px;
    background: #fb641b;
    color: white;
    font-size: 16px;
    font-weight: bold;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    text-decoration: none;
    display: inline-block;
    margin-top: 15px;
}

.back-home-btn:hover {
    background: #e25e14;
}

@media (max-width: 768px) {
    .confirm-container {
        width: 90%;
    }
}
</style>

<div class="confirm-container">
    <div class="confirm-header">Payment Successful</div>
    <div class="confirm-icon">✅</div>
    <div class="confirm-message">Thank you for your order!</div>
    <div class="order-details">Order ID: <?php echo htmlspecialchars($orderId); ?><br>Amount Paid: ₹<?php echo number_format($orderAmount, 2); ?></div>
    <a href="index.php" class="back-home-btn">Continue Shopping</a>
</div>

<?php include 'partials/_footer.php'; ?>