<?php
ob_start();
include 'header.php';
include 'partials/_categories_nav.php';

if (!isset($_SESSION['orderId']) || !isset($_SESSION['orderAmount'])) {
    header('location:index.php');
    exit();
}

$orderId = $_SESSION['orderId'];
$orderAmount = $_SESSION['orderAmount'];
?>

<style>
.payment-section {
    background: #f1f3f6;
    min-height: 100vh;
    padding: 40px 0;
}

.payment-container {
    max-width: 800px;
    margin: 0 auto;
}

.payment-header {
    background: white;
    padding: 16px;
    border-radius: 4px;
    margin-bottom: 20px;
    box-shadow: 0 1px 2px 0 rgba(0,0,0,.2);
}

.step-progress {
    display: flex;
    justify-content: space-between;
    margin: 20px 0;
}

.step {
    display: flex;
    align-items: center;
    gap: 8px;
}

.step-circle {
    width: 25px;
    height: 25px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    color: #fff;
    background: #2874f0;
}

.accordion-button {
    padding: 20px;
    font-weight: 500;
}

.accordion-button:not(.collapsed) {
    background: #f8f9fa;
    color: #2874f0;
}

.payment-option {
    padding: 20px;
}

.upi-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 15px;
    margin-top: 15px;
}

.upi-option {
    border: 1px solid #e0e0e0;
    border-radius: 4px;
    padding: 15px;
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.upi-option:hover {
    border-color: #2874f0;
    background: #f8f9fa;
}

.upi-option img {
    width: 30px;
    height: 30px;
    object-fit: contain;
}

.disabled-option {
    opacity: 0.5;
    pointer-events: none;
}

.pay-button {
    background: #fb641b;
    color: #fff;
    padding: 16px 30px;
    border: none;
    border-radius: 4px;
    font-weight: 500;
    width: 100%;
    margin-top: 20px;
    cursor: pointer;
    transition: background 0.3s ease;
}

.pay-button:hover {
    background: #e45016;
}

.amount-section {
    background: white;
    padding: 16px;
    border-radius: 4px;
    margin-top: 20px;
    box-shadow: 0 1px 2px 0 rgba(0,0,0,.2);
}

.amount-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid #f0f0f0;
}

.amount-row:last-child {
    border: none;
    font-weight: 600;
}
</style>

<div class="payment-section">
    <div class="payment-container">
        <div class="payment-header">
            <h5 class="mb-0">Payment Options</h5>
            <div class="step-progress">
                <div class="step">
                    <div class="step-circle">✓</div>
                    <span>Cart</span>
                </div>
                <div class="step">
                    <div class="step-circle">✓</div>
                    <span>Address</span>
                </div>
                <div class="step">
                    <div class="step-circle">3</div>
                    <span>Payment</span>
                </div>
                <div class="step">
                    <div class="step-circle">4</div>
                    <span>Summary</span>
                </div>
            </div>
        </div>

        <div style="padding: 10px;">
    <h4 style="font-weight: 600;">Select Payment Method</h4>
    <div style="display: flex; align-items: center; gap: 10px; padding: 20px; background: #c9dde0; margin-top:15px;" >
        <span><img src="<?php echo $URL; ?>/assets/images/brands/gpay2.png" width="50"></span>
        <span style="white-space: nowrap;">Payment online and get 33% extra off</span>
    </div>
</div>



                    <!-- Disabled Card Payment -->
            <div class="accordion-item disabled-option">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" disabled>
                        <i class="fas fa-credit-card me-2"></i> Card Payment
                    </button>
                </h2>
            </div>

            <!-- Disabled COD -->
            <div class="accordion-item disabled-option">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" disabled>
                        <i class="fas fa-money-bill me-2"></i> Cash on Delivery
                    </button>
                </h2>
            </div>

        <div class="accordion" id="paymentAccordion">
            <!-- UPI Payment Option -->
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#upiCollapse">
                        <i class="fas fa-mobile-alt me-2"></i> UPI Payment
                    </button>
                </h2>
                <div id="upiCollapse" class="accordion-collapse collapse show" data-bs-parent="#paymentAccordion">
                    <div class="accordion-body">
                        <div class="upi-options">
                            <label class="upi-option">
                                <input type="radio" name="upi_app" value="gpay" hidden>
                                <img src="<?php echo $URL; ?>/assets/images/brands/gpay.png" width="80">
                                <span>Google Pay</span>
                            </label>
                            <label class="upi-option">
                                <input type="radio" name="upi_app" value="phonepe" hidden>
                                <img src="<?php echo $URL; ?>/assets/images/brands/phonepe.png" width="80">
                                <span>PhonePe</span>
                            </label>
                            <label class="upi-option">
                                <input type="radio" name="upi_app" value="paytm" hidden>
                                <img src="<?php echo $URL; ?>/assets/images/brands/paytm.png" width="80">
                                <span>Paytm</span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>


            <!-- WhatsApp Payment -->
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#whatsappCollapse">
                        <i class="fab fa-whatsapp me-2"></i> WhatsApp Payment
                    </button>
                </h2>
                <div id="whatsappCollapse" class="accordion-collapse collapse" data-bs-parent="#paymentAccordion">
                    <div class="accordion-body">
                        <p style="padding: 20px;">Pay securely via WhatsApp</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="amount-section">
            <div class="amount-row">
                <span>Order Amount</span>
                <span>₹<?php echo number_format($orderAmount, 2); ?></span>
            </div>
            <div class="amount-row">
                <span>Total Amount</span>
                <span>₹<?php echo number_format($orderAmount, 2); ?></span>
            </div>
        </div>

        <button class="pay-button" onclick="processPayment()">
            Proceed to Pay
        </button>
    </div>
</div>

<script>
function processPayment() {
    let selectedUpi = document.querySelector('input[name="upi_app"]:checked');
    let amount = <?php echo $orderAmount; ?>;
    let upiId = "krishvaidi7@freecharge";

    if (!selectedUpi) {
        alert("Please select a payment method");
        return;
    }

    switch(selectedUpi.value) {
        case 'gpay':
            window.location.href = `upi://pay?pa=${upiId}&pn=Krish Vaidya&am=${amount}&cu=INR`;
            break;
        case 'phonepe':
            window.location.href = `phonepe://pay?pa=${upiId}&pn=Krish Vaidya&am=${amount}&cu=INR`;
            break;
        case 'paytm':
            window.location.href = `paytmmp://pay?pa=${upiId}&pn=Krish Vaidya&am=${amount}&cu=INR`;
            break;
    }

    // Show payment confirmation after a delay
    setTimeout(() => {
        if(confirm('Did you complete the payment?')) {
            window.location.href = "confirm_payment.php?orderId=<?php echo $orderId; ?>";
        }
    }, 3000);
}
</script>

<?php include 'partials/_footer.php'; ?>